#!/bin/bash

PASSLOGIC_CRON_LOCK=passlogic_cron.lock
LOG=/var/log/passlogic/passlogic_log_db_delete.log
log(){
    echo `date "+%Y-%m-%d %H:%M:%S"` $* >> $LOG
}

check_lock_file() {
	if [ ! -e /opt/passlogic/data/lock/$PASSLOGIC_CRON_LOCK ]
	then
		return 0
	else
		return 1
	fi
}

read_settings_conf() {
    if [ -e /opt/passlogic/data/conf/settings.conf ]
    then
	sed -n "s/^$1\s*=\s*\(\S\+\)\s*$/\1/p" /opt/passlogic/data/conf/settings.conf | head -1
    fi
}

border() {
    local border
    border=`date "+%s" -d "-$1 days"`
    border=$(( $border - $border % ( 3600 * 24 ) ))
    echo $border
}

older_than_ndays() {
    local days

    days=`read_settings_conf PL_LOG_DAYS`
    grep -q -E '^[0-9]+$' <<< "$days" && [ $days -ge 1 ]
    if ! [ $? -eq 0 ]
    then
	days=365
    fi

    echo $days
}

delete_log_records() {
    
    days=`older_than_ndays`
    query="delete from passlogic_log where time < `border $days`"
    result=`su - passlogic -c "/opt/passlogic/pgsql/bin/psql -h localhost -p 5439 -U passlogic -c '$query' 2>&1"`

    return $?
}

check_lock_file
if [ $? -eq 1 ]
then
	log LOG: $PASSLOGIC_CRON_LOCK exists.
	exit 1
fi

log LOG: Started deleting old log records in passlogic_log table...
delete_log_records

if [ $? -eq 0 ]
then
    log LOG: Finished deleting records older than $days days: $result
else
    log ERROR: Failed deleting records older than $days days: $result -- query was \'$query\'.
fi
