#!/bin/bash

init() {
	pm=/opt/passlogic/apps/tools/pm.sh

	dual_lock=false
	echo replication? | $pm | grep -q ':ok'
	if [ $? -eq 0 ]
	then
		echo remote_ping | $pm | grep -q ':ok'
		[ $? -eq 0 ] && dual_lock=true
	fi
}

call_pm() {
	echo $* | $pm | grep -q ':ok'
	return $?
}

init

# process_names にあるプロセスが 1 つでも存在していれば、マッチして 0 を返す。
#
process_names='userLdapCmd.php|userPasschgMail.php|stdImport.php|userimport.php|passlogic_adsync.php|passlogic_log_db_delete.sh'
call_pm proc_mon h -e -o cmd = -E "$process_names"
ret1=$?

if $dual_lock
then
	call_pm remote_proc_mon h -e -o cmd = -E "$process_names"
	ret2=$?
else
	ret2=1
fi

# - どちらかの系にプロセスが残っていれば 0 を返す
# - 両系にプロセスがない場合 1 を返す
#
[ $ret1 -eq 0 ] || [ $ret2 -eq 0 ]
exit $?

