#!/bin/bash

PASSLOGIC_CRON_LOCK=passlogic_cron.lock
PASSLOGIC_PDO_LOCK=pdo.lock
PATH=/opt/passlogic/apps/tools/:$PATH
pid=$$

trap "make_lock.sh $pid ${PASSLOGIC_CRON_LOCK} restore.sh -unlock" 0
make_lock.sh $pid ${PASSLOGIC_CRON_LOCK} restore.sh
[ $? -ne 0 ] && exit 4

timeout 300 bash -c 'while passlogic_cron_mon.sh ; do sleep 5; done'
[ $? -ne 0 ] && exit 4

trap "make_lock.sh $pid ${PASSLOGIC_PDO_LOCK} restore.sh -unlock; make_lock.sh $pid ${PASSLOGIC_CRON_LOCK} restore.sh -unlock" 0
make_lock.sh $pid ${PASSLOGIC_PDO_LOCK} restore.sh
[ $? -ne 0 ] && exit 4

FILENAME="passlogicbackup"

if [ -z $1 ]; then
        echo "please enter password"
        exit 1
fi

case "$2" in
    -d)
	db=1
	conf=0
	;;
    -c)
	db=0
	conf=1
	;;
    *)
	db=1
	conf=1
	;;
esac

# restore が異常終了した場合、passlogicbackup.tar.gz が残るので削除
rm -f /opt/passlogic/tmp/$FILENAME.tar.gz  
rm -Rf /opt/passlogic/tmp/$FILENAME
mkdir /opt/passlogic/tmp/$FILENAME
cd /opt/passlogic/tmp/$FILENAME

cd /opt/passlogic/tmp
unzip -P $1 /opt/passlogic/tmp/$FILENAME.zip
if [ $? -ne 0 ]; then
	exit 1
fi

if [ -e /opt/passlogic/tmp/$FILENAME.tar.gz ]; then
	tar zxvf /opt/passlogic/tmp/$FILENAME.tar.gz
else
	exit 2
fi

if [ $conf -eq 1 ]; then
    if [ -e /opt/passlogic/tmp/$FILENAME/data.tar.gz ]; then
	tar zxvf /opt/passlogic/tmp/$FILENAME/data.tar.gz -C /
    else
	exit 2
    fi

    if [ -e /opt/passlogic/tmp/$FILENAME/cron.tar.gz ]; then
	tar zxvf /opt/passlogic/tmp/$FILENAME/cron.tar.gz -C /
    fi
fi

ret_psql=0
if [ $db -eq 1 ]; then
    export PGUSER="passlogic"
    export PGDATABASE="passlogic"

    /opt/passlogic/pgsql/bin/psql -h localhost -p 9915 passlogic  < /opt/passlogic/tmp/$FILENAME/dbbackup.sql
    ret_psql=$?
    unset PGUSER
    unset PGDATABASE
fi

make_lock.sh $pid ${PASSLOGIC_PDO_LOCK} restore.sh -unlock
trap "make_lock.sh $pid ${PASSLOGIC_CRON_LOCK} restore.sh -unlock" 0

rm -Rf /opt/passlogic/tmp/$FILENAME.tar.gz
rm -Rf /opt/passlogic/tmp/$FILENAME.zip
rm -Rf /opt/passlogic/tmp/$FILENAME

# delete cache.
rm -Rf /opt/passlogic/tmp/*.cache

if [ $ret_psql -eq 0 ]
then
    exit 0
else
    exit 3
fi
