#!/usr/bin/php
<?php
// restore.sh が作ったlockfile がある場合は exit(1) する
require_once('/opt/passlogic/apps/lib/passlogic_lock.php');
if (PasslogicLock::cron_exists())
{
	exit(1);
}

define("BASE_DIR", "/opt/passlogic/apps/");
define("LIB_DIR", BASE_DIR."lib/");
define("PEAR_DIR", LIB_DIR."pear/");

require_once(PEAR_DIR."XML/Serializer.php");
require_once(LIB_DIR.'database/databaseManager.inc.php');
require_once(LIB_DIR.'database/passlogic_user.php');
require_once(LIB_DIR."xmlconf.inc.php");
require_once(LIB_DIR."ldap.inc.php");
require_once(LIB_DIR."crypt.inc.php");
require_once(LIB_DIR."log.inc.php");
require_once(LIB_DIR."passlogic_api_util.inc.php");

@date_default_timezone_set("Asia/Tokyo");

$plau = new passlogic_api_util();

$progname = "passlogic_adsync";
$logfile = "/var/log/passlogic/". $progname. ".log";

$crypt = new Crypt;

$MaxPageSize = 0;
if(strlen($argv[1]) > 0){
	$int = intval($argv[1]);
	if($int > 0){
		$MaxPageSize = $int;
	}
}
if($MaxPageSize <= 0){
	$MaxPageSize = 100;
}

function to_logfile($string){
	global $progname, $logfile;
	file_put_contents($logfile, date("Y/m/d H:i:s")." ".$string."\n", FILE_APPEND);
}

function get_LDAP_users($passlogicuser, $ldap, $ldapbindpasswd, $ldapconfig){
	unset($ldapusers);

	if ($ldapconfig['ldapType'] == 'ActiveDirectory') {
		$filter = "(objectclass=user)";
	}else if ($ldapconfig['ldapType'] == 'OpenLDAP') {
		$filter = "";
	}else{
		return FALSE;
	}

	$tmpfilter = "";
	foreach($passlogicuser as $key => $val){
		$tmpfilter .= "(".$ldapconfig['ldapAttrUid']."=".$val['uid'].")";
	}
	if(strlen($tmpfilter) > 0){
		$filter .= "(|".$tmpfilter.")";
	}
	if( $ldapconfig['ldapFilter'] ){
		$filter = "(&{$ldapconfig['ldapFilter']}{$filter})";
	}
	$ldapusers = $ldap->_search($ldapconfig['ldapTopObject'], $filter, $ldapconfig['ldapAttrUid'], $ldapconfig['ldapAttrUemail']);

	return $ldapusers;
}

// log
$plLog = new PasslogicLog();
$log_code = $plLog->_get_log_xml();
$plLog->log('31101', $progname, 'ALL');
to_logfile($log_code['31101']['message']."(31101)");



/************************************/
/***** Phase 1: get ldap config *****/
/************************************/

$xmlconfobj = new xmlconf();
// confファイルの読み込み
$xmlconf = $xmlconfobj->_get_xmlconf();

// get all ldap settings
if(isset($xmlconf['passlogicConfig']['ldap']['ldapConfig'])){
	if (isset($xmlconf['passlogicConfig']['ldap']['ldapConfig'][0])) {
		$ldapConfigs = $xmlconf['passlogicConfig']['ldap']['ldapConfig'];
	} else {
		$ldapConfigs[] = $xmlconf['passlogicConfig']['ldap']['ldapConfig'];
	}
}

if(count($ldapConfigs) <= 0){
	exit;
}



$users_db = new passlogic_user(getPDO());
foreach($ldapConfigs as $ldapconfig){
	// LDAP 認証連携ではない場合 SKIP
	if(!$ldapconfig['ldapHostname']){
		continue;
	}
	unset($domain);
	unset($ldap);
	unset($ldapusers);
	unset($passlogicusers);
	unset($hostArr);
	unset($ldapHost);

	$domain = $ldapconfig['groupname'];

	// If v1.3.0 or later, bind password is encrypted in xmlconf.
	// So you have to decrypt $ldapconfig['ldapBindpasswd'];

	// for v1.2.3
	//$ldapbindpasswd = $ldapconfig['ldapBindpasswd'];
	// for v1.3.0 or later
	$ldapbindpasswd = $crypt->decrypt_string($ldapconfig['ldapBindpasswd'], $domain);

	// ldap操作クラス
	$hostArr = array($ldapconfig['ldapHostname'], $ldapconfig['ldapHostname2']);
	$hostArr = array_filter($hostArr , "strlen");
	$bind_done = false;
	foreach ($hostArr as $key => $val) {
		$ldap = new ldap();
		if(!$ldap->_bind($val, $ldapconfig['ldapPort'], $ldapconfig['ldapBinddn'], $ldapbindpasswd, $ldapconfig['ldapTopObject'], $ldapconfig['ldapSecure'])){
			to_logfile("ldap bind error. domain=". $domain." server=".$val);
			continue;
		}else{
			$ldapHost = $val;
			$bind_done = true;
			break;
		}
	}
	if(!$bind_done){
		to_logfile("ldap bind error. domain=". $domain." ALL SERVERS");
		continue;
	}

	/****************************************/
	/***** Phase 2: get passlogic users *****/
	/****************************************/
	$conditions    = array( 'domain' => $domain );
	$params_column = array( 'uid' );
	$rs0 = $users_db->query_userlist($conditions, $params_column, array('uid' => 'ASC'));

	$domain_total = count($rs0);
	if ($domain_total == 0) {
		continue;
	}
	$loopmax = (int)(ceil($domain_total / $MaxPageSize));

	$loop = 0;
	do{
		$offset = $MaxPageSize * $loop;
		$rs = array_slice($rs0, $offset, $MaxPageSize);

		if(!$rs){
			to_logfile("Failed to read passlogic users. domain=". $domain. ", offset=". $offset);
			break;
		}

		if($rs){
			if(count($rs) <= 0){
				break;
			}
			else{
				foreach($rs as $user){
					$passlogicusers[$loop][] = $user;
				}
				if(count($rs) >= $MaxPageSize){
					$loop++;
					if($loop >= $loopmax){
						break;
					}
				}
				else{
					break;
				}
			}
		}
	}while($loop);

	if(count($passlogicusers) <= 0){
		continue;
	}
	foreach($passlogicusers as $loop => $passlogicuser){
		unset($ldapusers);

		/************************************/
		/***** Phase 3: get ldap users  *****/
		/************************************/
		$ldapusers = get_LDAP_users($passlogicuser, $ldap, $ldapbindpasswd, $ldapconfig);

		if($ldapusers === FALSE){
			if( $ldap->err ){
				to_logfile($ldap->err." domain=". $domain);
			}else{
				to_logfile("ldap search error. domain=". $domain);
			}
		}
		else{
			// if $ldapusers is not FALSE, $ldapusers is an array.

			/*******************************************************/
			/***** Phase 4: remove passlogic users Not in LDAP *****/
			/*******************************************************/

			if(count($passlogicuser) > 0){ // to prevent an error in foreach
				foreach($passlogicuser as $key => $val){
					if(array_search($val['uid'], $ldapusers) === FALSE){
						$ret = $plau->userdelete($val['uid'], $domain);
						$code    = $ret['code'];
						$message = $log_code[$code]['message']."({$code})";
						if ( $ret['code'] == '30003') {
							to_logfile("user deleted., ".$val['uid']."@". $domain.", ". $message);
						}
						else {
							to_logfile("userdelete error., ".$val['uid']."@". $domain.", ". $message);
						}
					}
				}
			}
		}
	}
}

$plLog->log('31102', $progname, 'ALL');
to_logfile($log_code['31102']['message']."(31102)");

?>
