#!/bin/bash

# pid=$1
# lockfile=$2
# unlock=$3
# ppname=$4
# pm=/opt/passlogic/apps/tools/pm.sh
# dual_lock
init() {
	pid=$1
	lockfile=$2
	pproc=$3
	unlock=$4
	pm=/opt/passlogic/apps/tools/pm.sh
	logfile=/var/log/passlogic/pm.log

	dual_lock=false
	echo replication? | $pm | grep -q ':ok'
	if [ $? -eq 0 ]
	then
		echo remote_ping | $pm | grep -q ':ok'
		[ $? -eq 0 ] && dual_lock=true
	fi
}

call_pm() {
	echo $* | $pm | grep -q ':ok'
	return $?
}

log() {
	echo log_activity $* | $pm > /dev/null
}

init $*

if [ "$unlock" == '-unlock' ]
then
	if $dual_lock
	then
		log make_lock.sh $pid $lockfile $pproc -unlock called
	else
		log make_lock.sh $pid $lockfile $pproc -unlock called \(single lock file\)
	fi

	call_pm unlock $pid $lockfile
	ret1=$?

	if $dual_lock
	then
		call_pm remote_unlock $pid $lockfile
		ret2=$?
	else
		ret2=0
	fi

	[ $ret1 -eq 0 ] && [ $ret2 -eq 0 ]
	exit $?

else
	if $dual_lock
	then
		log make_lock.sh $pid $lockfile called
	else
		log make_lock.sh $pid $lockfile called \(single lock file\)
	fi

	call_pm lock $pid $lockfile 10 /opt/passlogic/apps/tools/lock_mon.sh $pid $pproc
	ret=$?

	if [ $ret -eq 1 ]
	then
		exit 1
	fi

	if ! $dual_lock
	then
		exit 0
	fi

	call_pm remote_lock $pid $lockfile 10 /opt/passlogic/apps/tools/lock_mon.sh $pid $pproc remote
	ret=$?

	if [ $ret -eq 1 ]
	then
		exit 1
	fi
fi
