<?php
require_once('/opt/passlogic/apps/lib/passlogic_lock.php');
/**
 * PDOオブジェクトを取得する。<br>
 * 未定義の場合は生成して返す。
 * @return PDOオブジェクト
 */
function getPDO() {
	static $pdo;

	// restore.sh が作ったlockfile がある場合は NULL を返す
	if (PasslogicLock::pdo_exists()) {
		return NULL;
	}
	
	if (!isset($pdo)) {
		$is_success     = FALSE;
		$error_messages = array();
		// PDO作成失敗時に何度試行するか。
		$MAX_RETRY_COUNT = 3; 
		// PDO作成失敗時に次の試行までに何秒待機するか。
		$WAIT_SECONDS = 1;

		for ($i = 1; $i <= $MAX_RETRY_COUNT; $i++) {
			// DB接続設定
			$dsn = 'pgsql:dbname=passlogic;host=localhost;port=9915;user=passlogic;';
			try {
				$pdo = new PDO($dsn);
				$is_success = TRUE;
				break;
			} catch (PDOException $e) {
				$error_messages[] = ("Error: fail to create PDO object at {$i} times. reason: ".$e->getMessage());
				sleep($WAIT_SECONDS);
			}
		}

		if ( !$is_success ) {
			$str_error_messages = implode("<br />\n", $error_messages);
			print($str_error_messages);
			exit;
		}
	}

	return $pdo;
}
?>