<?php

// restore.sh が作ったlockfile がある場合は exit(1) する
require_once('/opt/passlogic/apps/lib/passlogic_lock.php');
if (PasslogicLock::cron_exists())
{
	exit(1);
}

//処理時間を無制限にする
set_time_limit(0);


define("DEFAULT_POLICY", 'Default Policy');

/**
 * REQUEST_METHOD がある場合、ポリシー設定画面で、有効期限切れお知らせメールを
 * 「すぐにメール送信」ボタンが押下されたと判断
 *
 * restore.sh は userPassChgMail.php 実行中にリストアをしないようにプロセス存在確認を
 * する。 そのため httpd ではなく php プロセスとして見えるように自身を php コマンドで実行
 *
 * 「すぐにメール送信」はコールバック未指定の XMLHttpRequest。
 *   php コマンド終了後は何も返さず終了する(空文字列を返却)
 */
if (isset($_SERVER['REQUEST_METHOD'])) {

	// arg1
	$policy=DEFAULT_POLICY;
	if (isset($_GET['policy']) && $_GET['policy'] != DEFAULT_POLICY) {
		$policy = $_GET['policy'];
	}

	// arg2
	if (isset($_GET['day1']) && isset($_GET['day2']) && isset($_GET['passchgdays'])) {
		$day1 = $_GET['day1'];
		$day2 = $_GET['day2'];
		$passchgdays = $_GET['passchgdays'];
		$arg2="$day1,$day2,$passchgdays";
	}

	exec("/usr/bin/php /opt/passlogic/apps/admin/userPasschgMail.php '$policy' '$arg2'> /dev/null 2>&1");
	exit;
}


// Cut out from "config.inc.php" -----------------------------------------------
date_default_timezone_set("Asia/Tokyo");
define("BASE_DIR", dirname(dirname(__FILE__)));
define("LIB_DIR", BASE_DIR . '/lib');
define("PEAR_DIR", LIB_DIR . '/pear');

// application DEBUG true / false
define("DEBUG", 0);

require_once(LIB_DIR."/log.inc.php");
require_once(LIB_DIR."/passlogic.inc.php");
require_once(LIB_DIR."/database/databaseManager.inc.php");

$plLog = new PasslogicLog();
$plinc = new passlogicInc();

// ポリシー名 3 セット
//
// $config_policy: passlogic-config.xml 内で管理しているポリシー名
// $query_policy: DB の passlogic_user.policy カラムで管理しているポリシー名
// $policy: 管理画面の表示上のポリシー名, userPasschgMail.php の第一引数で与えるポリシー名
//
// デフォルトポリシーの時は
//   $config_policy = 'passlogicConfig'
//   $query_policy = ''
//   $policy = 'Default Policy'
//
// デフォルトポリシー以外では、$config_policy = $query_policy = $policy となる

$config_policy = 'passlogicConfig';
$query_policy = '';
$policy = DEFAULT_POLICY;
$is_web_request = false;

if (isset($argv[1]) && $argv[1] != $policy) {
   $config_policy = $argv[1];
   $query_policy = $config_policy;
   $policy = $query_policy;
}

// 第2 引数がある場合、Web からのリクエスト
//
// $day1, $day2, $passchgdays を取得
//
if (isset($argv[2])) {
	$ary = explode(',', $argv[2]);
	if (count($ary) == 3 ) {
		$is_web_request = true;
		list($day1, $day2, $passchgdays) = $ary;
        } else {
		// 設定値が正しくない
		$plLog->log("34005", '', '');
	return false;
        }
}

$xmlconfobj = new xmlconf();
$xmlconfobj_policy = $xmlconfobj->_get_xmlconf();
$passlogic_policy_conf = $xmlconfobj_policy[$config_policy];

if (!$is_web_request) {
	if ($passlogic_policy_conf['isPasschgTimeup'] == 'false') {
		// パスワード有効期限が無制限
		$plLog->log("34003", '', '');
		return false;
	}
	if ($passlogic_policy_conf['notice_passchg_hour'] == '--') {
		// メール通知設定が無効
		$plLog->log("34004", '', '');
		return false;
	}
	if (!is_numeric($passlogic_policy_conf['notice_passchg_days_1']) || !is_numeric($passlogic_policy_conf['notice_passchg_days_2'])) {
		// 設定値が正しくない
		$plLog->log("34005", '', '');
		return false;
	}
	$day1 = intval($passlogic_policy_conf['notice_passchg_days_1']);
	$day2 = intval($passlogic_policy_conf['notice_passchg_days_2']);
	$passchgdays = intval($passlogic_policy_conf['passchgtimeupdays']);
}
$time1 = $day1 * 60 * 60 * 24;
$time2 = $day2 * 60 * 60 * 24;

// パラメータのチェック
if (!is_numeric($passchgdays) || $passchgdays < 0 ||
		!is_numeric($day1) || $day1 < 0 || $time1 > $passchgdays ||
		!is_numeric($day2) || $day2 < 0 || $time2 > $passchgdays) {
	// パラメータの設定が正しくない
	$plLog->log("34006", '', '');
} else {
	$range_min = time() - $passchgdays + min($time1, $time2);
	$range_max = $range_min + abs($time1 - $time2);

	$user_db = new passlogic_user(getPDO());
	$rs_list = $user_db->get_user_list_for_notice_expire($query_policy, $range_min, $range_max);
	$mail_count = count($rs_list);

	// 対象ユーザにメールを送信
	// 処理の開始を記録
	$plLog->log("34001", '', '', array('additional_message'=>'policy:'.$policy));
	sleep(1);
	if ($mail_count > 0) {
		foreach($rs_list as $user) {
			if (strlen($user['uemail']) == 0) {
				// メールアドレスが登録されていない
				$plLog->log('34008', $user['uid'], $user['domain']);
				continue;
			}
			$params = array(
					"uid" => $user['uid'],
					"domain" => $user['domain'],
					"type" => "user",
					"num" => null,
					"client_info" => null
			);

			$ret = $plinc->sendnotice("passchg", $params);
			if ($ret) {
				// メール送信に成功 (失敗時はsendnotice()内で31014でログに書かれる)
				$plLog->log('34007', $user['uid'], $user['domain']);
			}
		}
	}
	sleep(1);
	// 処理の終了を記録
	$plLog->log("34002", '', '', array('additional_message'=>'policy:'.$policy));
}
?>

