<?php
// config file
require_once("./config.inc.php");
include(TMPL_DIR."/html_header.ihtml.php");

?>
	<?php echo LANG_RESTORE_TEXT1?>

	<br>
	<br>

	<?php
	// register backup file
	if ($_POST['sub']=="restore") {
		$password = $_POST['password'];
		switch($_POST['restore_mode']) {
			case "1":
				// 全体
				$restore_mode = '';
				$log_code = '32002';
				break;
			case "2":

				$restore_mode = '-d';
				$log_code = '32003';
				break;
			case "3":
				$restore_mode = '-c';
				$log_code = '32004';
				break;
			default:
				$restore_mode = '';
				$log_code = '32002';
		}

		@unlink("/opt/passlogic/tmp/passlogicbackup.zip");
		if (move_uploaded_file($_FILES['passlogicfile']['tmp_name'], "/opt/passlogic/tmp/passlogicbackup.zip")) {
			// コマンドの /dev/null の後に"&"を付加するとバックグラウンド実行になりexec関数の戻り値が取得できなくなるため"&"は記述していません。
			$cmd = "/usr/bin/sudo ".TOOLS_DIR."/restore.sh ".escapeshellarg($password)." {$restore_mode} > /dev/null";
			exec($cmd, $output, $ret);

			if ($ret == '0') {
				print LANG_RESTORE_DONE;

				$admin = new admin_model($_SESSION['_auth']['uid']);
				$admin->select_from_db();
				$admindata = $admin->get_userdata();
				if($admindata['role'] != 'admin'){
					unset($_SESSION['_auth']);
				}

				// PKIの設定をDBからlocalへ
				require_once(LIB_DIR."/cert_util.inc.php");
				$cert_util = new cert_util();
				$cert_util->updatePKIsetting();

				// radiusd再起動
				$cmd = "/usr/bin/sudo ".TOOLS_DIR."/radiusd_restart.sh";
				exec($cmd);

				// httpd再起動
				$cmd = "/usr/bin/sudo ".TOOLS_DIR."/httpd_restart.sh > /dev/null &";
				exec($cmd);

				//log
				$plLog->log($log_code, $auth_admin["uid"], $auth_admin["domain"]);
			} elseif ($ret == '1') {
				print LANG_RESTORE_ERROR1;
			} elseif ($ret == '2') {
				print LANG_RESTORE_ERROR2;
			} elseif ($ret == '4') {
				print LANG_RESTORE_ERROR4;
			} else {
			// 0,1,2,4 以外
				print LANG_RESTORE_ERROR3;
			}
		}
	}
	?>

	<br>

    <div id="blocker" style="position: absolute; top: 0px; left: 0px; width: 100vw; height: 100vh; opacity: 0.5; background-color: rgb(175, 175, 175); display: none; z-index: 9999999"></div>


	<script>
	function check() {
		res = confirm("<?php echo LANG_RESTORE_CONFIRM?>");
		if(res == false) {
			return false;
		}
		document.querySelector('#blocker').style.display = 'block';
	}
	</script>

	<form name="restoreForm" id="restoreForm" method="post" action="<?php echo PHP_SELF?>" enctype="multipart/form-data" onsubmit="return check()">
	<input type="hidden" name="action" value="done">

	<table>
	<tr>
		<th><?php echo LANG_RESTORE_BACKUPFILE?></th>
		<td>
			<input type="file" class="passlogic_css_file" name="passlogicfile" value="">
		</td>
	</tr>
	<tr>
		<th><?php echo LANG_BACKUP_PASSWORD?></th>
		<td>
			<input type="password" class="passlogic_css_password" name="password" value="">
		</td>
	</tr>
	<tr>
		<th><?php echo LANG_RESTORE_MODE?></th>
		<td>
				<select name="restore_mode">
				<option value="1" selected><?php echo LANG_RESTORE_MODE1?></option>
				<option value="2"><?php echo LANG_RESTORE_MODE2?></option>
				<option value="3"><?php echo LANG_RESTORE_MODE3?></option>
				</select>
		</td>
	</tr>
	</table>

	<input type="submit" class="passlogic_css_submit" name="submit" value="<?php echo LANG_CNT_SEND?>">
	<input type="hidden" name="sub" value="restore">

	</form>

	<br>

<?php include(TMPL_DIR."/html_footer.ihtml.php");?>
