#!/usr/bin/php
<?php
/**
 * restore.sh が作ったlockfile がある場合は exit 1
 */
require_once('/opt/passlogic/apps/lib/passlogic_lock.php');
if (PasslogicLock::cron_exists())
{
	exit(1);
}
define("DEBUG", 0);

date_default_timezone_set("Asia/Tokyo");

define("BASE_DIR", dirname(dirname(dirname(__FILE__))));
define("LIB_DIR", BASE_DIR . '/lib');
define("PEAR_DIR", LIB_DIR . '/pear');
define("DATA_DIR", '/opt/passlogic/data');
define("TMP_DIR", "/opt/passlogic/tmp");


/**
 * settings
 */
require_once(LIB_DIR . "/config_reader.inc.php");
$settings = new ConfigReader(DATA_DIR . '/conf/settings.conf');
$settings->set_global_define();

ini_set('include_path', PEAR_DIR . DIRECTORY_SEPARATOR);

// passlogic component
require_once(LIB_DIR . "/passlogic.inc.php");
require_once(LIB_DIR . "/log.inc.php");
require_once(LIB_DIR . "/crypt.inc.php");
require_once(LIB_DIR . "/rijndael.inc.php");
require_once(LIB_DIR . "/validator.inc.php");
require_once(LIB_DIR . "/xmlconf.inc.php");
require_once(LIB_DIR . "/passlogic_api_util.inc.php");
require_once(LIB_DIR . '/model/user_model.php');

class stdImport {

	public function __construct() {

		$this->plinc = new passlogicInc();
		$this->rijndael = new PL_Rijndael;
		$this->validator = new Validator();
		$this->plau = new passlogic_api_util();
		$this->plLog = $this->plau->plLog;
		$this->xmlconfobj = $this->plau->xmlconfobj;
		$this->xmlconf = $this->plau->xmlconf;
		$this->crypt = $this->plau->crypt;
	}

	public function main($passlogicdata_dir, $param_name, $adpassword, $host_ip, $client_ip, $client_ua) {
		// ログ用の出力パラメータ
		$this->client_info = array(
		    'host_ip' => $host_ip,
		    'client_ip' => $client_ip,
		    'client_ua' => $client_ua
		);

		// インポート開始のログ出力
		$this->plLog->log('33001', '', '', $this->client_info);

		$this->import_st_data($passlogicdata_dir);
		$this->import_config();

		// ユーザ登録
		foreach ($this->usr_list as $filename) {
			$this->create_user($passlogicdata_dir, $param_name, $adpassword, $filename);
		}
		unset($this->usr_list);

		$this->plLog->log('33002', '', '', $this->client_info);

		// delete the directory /opt/passlogic/tmp/passlogic-std/
		$cmd1 = "rm -rf /opt/passlogic/tmp/passlogic-std/ > /dev/null";
		exec($cmd1, $ret);
		// delete the directory /opt/passlogic/tmp/passlogic-std.zip
		$cmd2 = "rm -rf /opt/passlogic/tmp/passlogic-std.zip > /dev/null";
		exec($cmd2, $ret);
	}

	private function import_st_data($passlogicdata_dir) {
		$passlogicdata_usrdir = $passlogicdata_dir . '/usr';
		$passlogicdata_lstdir = $passlogicdata_dir . '/lst';
		$passlogicdata_latdir = $passlogicdata_dir . '/lat';
		$passlogicdata_npadir = $passlogicdata_dir . '/npa';

		// 変数初期化
		$this->usr_list = array();
		$this->lock_list = array();
		$this->lat_list = array();
		$this->npa_list = array();

		// ユーザ情報の読み込み前に除外対象ファイル(admin, operator関連)のリストを作成
		$exclude_filelist = array('.', '..', 'admin');
		$admin_work = $this->rijndael->_decrypt_array("{$passlogicdata_lstdir}/admins");
		if ($admin_work != false) {
			foreach ($admin_work as $key1 => $val1) {
				foreach ($val1 as $key2 => $val2) {
					// adminのユーザ名をファイル名フォーマットに変換
					$admin_file_name = $this->rijndael->str_to_PLencodeformat($key2);
					$exclude_filelist[] = $admin_file_name;
				}
			}
		}
		$ope_work = $this->rijndael->_decrypt_array("{$passlogicdata_lstdir}/operators");
		if ($ope_work != false) {
			foreach ($ope_work as $key1 => $val1) {
				foreach ($val1 as $key2 => $val2) {
					// operatorのユーザ名をファイル名フォーマットに変換
					$operator_file_name = $this->rijndael->str_to_PLencodeformat($key2);
					$exclude_filelist[] = $operator_file_name;
				}
			}
		}

		// ユーザデータ読み込み
		$usr_handle = opendir($passlogicdata_usrdir);
		if ($usr_handle) {
			// usrディレクティブ内のファイル一覧からユーザを抽出
			while (false !== ($file = readdir($usr_handle))) {
				if (!in_array($file, $exclude_filelist)) {
					$this->usr_list[] = $file;
				}
			}
			closedir($usr_handle);
		} else {
			$this->plLog->log('33012', '', '', $this->client_info);
		}

		// ロックデータ読み込み
		$lst_handle = opendir($passlogicdata_lstdir);
		if ($lst_handle) {
			while (false !== ($file = readdir($lst_handle))) {
				if (preg_match("/^(.*)\.lock$/", $file, $matches)) {
					$fp = fopen("{$passlogicdata_lstdir}/{$file}", 'rb');
					$this->lock_list[$matches[1]] = rtrim(fgets($fp, 4089));
					fclose($fp);
				}
			}
			closedir($lst_handle);
		} else {
			$this->plLog->log('33012', '', '', $this->client_info);
		}

		// ロックカウントデータ読み込み
		$lat_handle = opendir($passlogicdata_latdir);
		if ($lat_handle) {
			while (false !== ($file = readdir($lat_handle))) {
				if (1 === preg_match("/^(.*)\.err$/", $file, $matches)) {
					$fp = fopen("{$passlogicdata_latdir}/{$file}", 'rb');
					$this->lat_list[$matches[1]] = rtrim(fgets($fp, 4089));
					fclose($fp);
				}
			}
			closedir($lat_handle);
		} else {
			$this->plLog->log('33012', '', '', $this->client_info);
		}

		// 「パスワード履歴」取得
		$npa_handle = opendir($passlogicdata_npadir);
		if ($npa_handle) {
			while (false !== ($file = readdir($npa_handle))) {
				// 「パスワード履歴」復号化
				$this->npa_list[$file] = $this->rijndael->_decrypt_array("{$passlogicdata_npadir}/{$file}");
			}
			closedir($npa_handle);
		} else {
			$this->plLog->log('33012', '', '', $this->client_info);
		}
	}

	private function import_config() {
		$this->groups = array();
		$this->groupname = array();

		// グループ設定取得
		if (is_array($this->xmlconf['passlogicConfig']['groups']['data'])) {
			// グループ複数
			$this->groups = $this->xmlconf['passlogicConfig']['groups']['data'];
		} elseif ($this->xmlconf['passlogicConfig']['groups']['data']) {
			// グループ一つだけの場合、xmlがarrayになっていないので、array化
			$this->groups[] = $this->xmlconf['passlogicConfig']['groups']['data'];
		}

		// ドメイン名リストを取得(AD連携の設定も含む)を取得
		if (isset($this->xmlconf['passlogicConfig']['ldap']['ldapConfig'])) {
			if (isset($this->xmlconf['passlogicConfig']['ldap']['ldapConfig'][0])) {
				foreach ($this->xmlconf['passlogicConfig']['ldap']['ldapConfig'] as $val) {
					$this->groupname[] = $val['groupname'];
				}
			} else {
				if (isset($this->xmlconf['passlogicConfig']['ldap']['ldapConfig']['groupname'])) {
					$this->groupname[] = $this->xmlconf['passlogicConfig']['ldap']['ldapConfig']['groupname'];
				}
			}
		}
	}

	private function create_user($passlogicdata_dir, $param_name, $adpassword, $filename) {
		// ユーザデータ取得
		$user_file = $this->rijndael->_decrypt_array($passlogicdata_dir . '/usr/' . $filename);

		// uid文字数切り捨て(ログテーブルが255文字超過でエラーになる為)
		$s_uid = $user_file['USER']['uid'];
		if (255 < mb_strlen($s_uid, "UTF-8")) {
			$s_uid = mb_substr($s_uid, 0, 255, "UTF-8");
		}

		// st版のuidが@を含んでいるかチェック
		if (preg_match("/@/", $s_uid) === 1) {
			// @の前後でuidとdomainを分ける
			$array = explode('@', $s_uid, 2);
			$s_parse_uid = $array[0];
			$s_parse_domain = $array[1];

			if ($s_parse_domain !== 'local') {
				// ドメインの有無をチェック
				if (!in_array($s_parse_domain, $this->groupname)) {
					// ドメインがない場合は取り込み出来ない
					$this->plLog->log('50150', $s_parse_uid, $s_parse_domain, $this->client_info);
					unset($user_file);
					return false;
				}
			}
		} else {
			// 分割なしでデフォルト値を設定
			$s_parse_uid = $s_uid;
			$s_parse_domain = 'local';
		}

		// ユーザの作成
		$user = new user_model($s_parse_uid, $s_parse_domain);
		$user_data = array(
		    'uid' => $s_parse_uid,
		    'domain' => $s_parse_domain,
		);

		// ユーザ存在チェック
		if ($user->is_exist()) {
			// ユーザが存在する場合、ログ書き込み
			$this->plLog->log('33010', $s_parse_uid, $s_parse_domain, $this->client_info);
			return false;
		}

		// 「無効フラグ」
		if (!empty($user_file['USER']['disabled'])) {
			if ($user_file['USER']['disabled'] == 'inactive') {
				$user_data['udisabled'] = 1;
			}
		}

		// 「初回パスワードﾞ変更済フラグ」
		if ($user_file['USER']['upasschged'] == 'Y') {
			$user_data['upasschged'] = 1;
		}

		// 「データ作成日時」チェック
		if (preg_match("/^(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})$/", $user_file['USER']['uent'], $matches) === 1) {
			$created_at = mktime($matches[4], $matches[5], $matches[6], $matches[2], $matches[3], $matches[1]);
			$user_data['created_at'] = $created_at;
		}

		// 文字数チェック(文字数切り捨て)
		$s_uname = $this->trim_str($user_file['USER']['uname'], $s_parse_uid, '40016', $s_parse_domain);  // 氏名
		$user_data['uname'] = $s_uname;
		$s_group1 = $this->trim_str($user_file['USER']['ugroup'], $s_parse_uid, '40011', $s_parse_domain);  // グループ
		$user_data['group1'] = $s_group1;
		$s_uemail = $this->trim_str($user_file['USER']['uemail'], $s_parse_uid, '40017', $s_parse_domain);  // メールアドレス
		$user_data['uemail'] = $s_uemail;
		$s_ucomment = $this->trim_str($user_file['USER']['ucomment'], $s_parse_uid, '40018', $s_parse_domain); // 備考
		$user_data['ucomment'] = $s_ucomment;

		foreach ($param_name as $i => $paramname) {
			if ($paramname != 'NON') {
				$std_paramname = "param" . strval($i + 1);
				if (!empty($user_file['USER'][$std_paramname])) {
					$status_code = strval(40001 + $i);
					$val = $this->trim_str($user_file['USER'][$std_paramname], $s_parse_uid, $status_code, $s_parse_domain);
					$user_data[$paramname] = $val;
				}
			}
		}
		if ($adpassword != 'NON') {
			$val = $this->trim_str($user_file['USER']['apppassword'], $s_parse_uid, '40019', $s_parse_domain);
			$user_data[$adpassword] = $val;
		}

		// ユーザロック状態
		if (isset($this->lock_list[$filename])) {
			$user_data['locked'] = 1;
			$user_data['lockedtime'] = $this->lock_list[$filename];
		}
		// ユーザ認証ミス回数
		if (isset($this->lat_list[$filename])) {
			$user_data['lockedcount'] = $this->lat_list[$filename];
		}
		// 「最終ﾛｸﾞｲﾝ/認証日時」チェック
		if (!empty($user_file['USER']['ulastlogin'])) {
			$user_data['lastauthdate'] = $user_file['USER']['ulastlogin'];
		}

		// 「パスワード履歴」整形
		if (isset($this->npa[$filename])) {
			$s_passsetold = "";
			foreach ($this->npa[$filename] as $val1) {
				foreach ($val1 as $val2) {
					// 「:0」を「;」に置換後、連結
					$s_passsetold .= preg_replace("/:0$/", ';', $val2);
				}
			}
			// 最後の「:0」除去
			$passsetold = preg_replace("/;$/", '', $s_passsetold);
			$user_data['passsetold'] = $passsetold;
		}

		// 変更なしデータを追加
		$user_data['uexpiry'] = $user_file['USER']['uexpiry'];
		$user_data['p1'] = $user_file['PASSSET']['p1'];
		$user_data['passsetdate'] = $user_file['USER']['passsetdate'];
		$user_data['uexpiry'] = $user_file['USER']['uexpiry'];

		// バリデーションチェック
		if (!$this->check_user_param($user_data)) {
			return false;
		}

		// $userにユーザデータを書込む
		foreach ($user_data as $key => $val) {
			$user->set_value($key, $val);
		}
		// ユーザデータをDBに書き込み
		$ret = $this->plau->usercreate($user);
		if ($ret['code'] != '30001') {
			// 正常に追加できていない場合、そこで処理終了
			return false;
		}

		// グループ存在チェック
		if ($s_group1 != '' && !in_array($s_group1, $this->groups)) {
			// 未定義グループの、グループ新規登録準備
			$a_work = array();
			if (empty($this->groups)) {
				// グループが一つもない
				$a_work[] = $s_group1;
			} else {
				// 既存グループの末尾に追加
				$a_work = $this->groups;
				$a_work[] = $s_group1;
			}
			$this->xmlconf['passlogicConfig']['groups']['data'] = $a_work;

			// グループ追加を書込む
			$this->xmlconfobj->_set_xmlconf($this->xmlconf);

			// グループ設定再取得
			$this->groups = $this->xmlconf['passlogicConfig']['groups']['data'];
		}
		unset($user_file);

		return true;
	}

	private function check_user_param($param) {
		$valid_arr = array(
		    'uid' => array(
			'Required' => array(
			    'rule' => 'Required',
			    'code' => '40100',
			),
			'Between' => array(
			    'rule' => array('Between', 1, 30),
			    'code' => '40100',
			),
			'Userid' => array(
			    'rule' => 'Userid',
			    'code' => '40100',
			),
		    ),
		    'domain' => array(
			'Domain' => array(
			    'rule' => 'Domain',
			    'code' => '40105',
			),
			'Between' => array(
			    'rule' => array('Between', 1, 20),
			    'code' => '40105',
			),
		    ),
		    'group1' => array(
			'Group' => array(
			    'rule' => 'Group',
			    'code' => '40101',
			),
		    ),
		    'uemail' => array(
			'Email' => array(
			    'rule' => 'Email',
			    'code' => '40102',
			),
		    ),
		    'uexpiry' => array(
			'Date' => array(
			    'rule' => 'Date',
			    'code' => '40103',
			),
		    ),
		);

		// validator
		$error = $this->_validator($valid_arr, $param);
		if ($error) {
			$this->plLog->log($error['code'], $param['uid'], $param['domain'], $this->client_info);
			return false;
		}
		return true;
	}

	private function _validator($valid_arr, $param) {
		if (!is_array($param)) {
			return false;
		}
		foreach ($valid_arr as $name => $valid) {
			if (!is_array($valid)) {
				return false;
			}
			foreach ($valid as $val) {
				$rule = $val['rule'];
				$ret = $this->validator->dispatchMethod($param["$name"], $rule);

				if (!$ret[0]) {
					if (is_array($rule['rule'])) {
						$params['error'] = $name . ":" . $rule[0];
					} else {
						$params['error'] = $name . ":" . $rule;
					}
					$params['code'] = $val['code'];
					break;
				}
			}
		}
		return $params;
	}

	// 255文字以内にカット
	private function trim_str($s_str, $s_uid, $s_code, $s_domain) {
		$s_ret = $s_str;
		if (255 < mb_strlen($s_str, "UTF-8")) {
			$s_ret = mb_substr($s_str, 0, 255, "UTF-8");
			$this->plLog->log($s_code, $s_uid, $s_domain, $this->client_info);
		}
		return $s_ret;
	}

}

/* --- 引数定義 --------------------------- */
// $argv[1] passlogicdata directory path
// $argv[2] destination of param1
// $argv[3] destination of param2
// $argv[4] destination of param3
// $argv[5] destination of param4
// $argv[6] destination of param5
// $argv[7] destination of param6
// $argv[8] destination of param7
// $argv[9] destination of param8
// $argv[10] destination of param9
// $argv[11] destination of param10
// $argv[12] destination of adpassword
// $argv[13] server host ip address
// $argv[14] client ip address
// $argv[15] client user agent
// application DEBUG true / false

$data_path = $argv[1];
for ($i = 2; $i < 12; $i++) {
	$param_name[] = $argv[$i];
}
$adpassword = $argv[12];
$host_ip = $argv[13];
$client_ip = $argv[14];
$client_ua = $argv[15];

$stdimport = new stdImport();
$stdimport->main($data_path, $param_name, $adpassword, $host_ip, $client_ip, $client_ua);

